/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_probe.c,v 1.36 2006/10/11 21:48:58 loic Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__request.h"
#include "mx__sleep.h"
#include "mx__error.h"
#include "mx__endpoint.h"

int mx__iprobe_common(mx_endpoint_t ep, uint64_t match_info,
		      uint64_t match_mask, mx_status_t *status);

MX_FUNC(mx_return_t)
mx_probe(mx_endpoint_t ep, uint32_t timeout, uint64_t match_info,
	 uint64_t match_mask, mx_status_t *status, uint32_t *result)
{
  if (match_info & ~match_mask) {
    return mx__error(ep, "mx_probe", MX_BAD_MATCH_MASK);
  }

  /* check that there's no wildcard in the context id range */
  if (!CHECK_MATCHING_WITH_CTXID(ep, match_mask)) {
    return mx__error(ep, "mx_probe", MX_BAD_MATCHING_FOR_CONTEXT_ID_MASK);
  }

  MX__MUTEX_LOCK(&ep->lock);
  MX__EP_STATS_INC(ep, wait);
  if (MX_DEBUG_CSUM && mx__opt.csum)
    match_mask &= UINT64_C(0x0000ffffffffffff);

  mx__luigi(ep);
  /* Go through one iteration of mx__iprobe_common to see if a matching
     unexpected message is already here. */
  *result = mx__iprobe_common(ep, match_info, match_mask, status);
  if (*result == 0) {
    uint32_t ctxid = CTXID_FROM_MATCHING(ep, match_info);
    struct mx__wait_queue wq;
    wq.result = 0;
    wq.type.probe.match_info = match_info;
    wq.type.probe.match_mask = match_mask;
    mx__sleep_on_wait_queue(ep, &wq, timeout, &ep->probe_waiters, &ep->ctxid[ctxid].probe_queue_head);
    if (wq.result) {
      /* TODO: The is the same work done in mx_iprobe_common. */
      mx_memcpy(status, &wq.type.probe.request->basic.status, sizeof (*status));
      *result = 1;
    }
    else {
      *result = 0;
    }
  } else {
    MX__EP_STATS_INC(ep, nonblocking_wait);
  }
  MX__MUTEX_UNLOCK(&ep->lock);
  return MX_SUCCESS;
}
